--Variables declaration
Declare @tck			as varchar(6)    -- Ticket Number if you need
Declare @DbName			as varchar(255)  -- variable to cursor
Declare @BackupDest		AS varchar(255)  -- variable to declare path to backup
Declare @BackupName		AS varchar(255)  -- variable to declare path to backup
Declare @dropDevice		AS varchar(255)  -- variable to declare path to backup
Declare @addDevice		AS varchar(255)  -- variable to declare path to backup
Declare @UsrName		as varchar(100)  -- Windows user who make backup
Declare @command		as varchar(2000) -- backup command
Declare @command2		as varchar(1000) -- verification command
Declare @srv			as varchar(150)  -- server name where databases are inside
--Set user variables
set @tck='XXXXXX'                    --only put the number of Ticket
--Set auto variables
set @UsrName=convert(varchar(150),REPLACE(SUSER_SNAME(),'\','.'))
set @srv=convert(varchar(150),ServerProperty('MachineName'))
--Cursor
DECLARE dbCursor CURSOR FOR select name from sysdatabases 
	where LEFT(name, 3) in ('ADB', 'ADC', 'PDB', 'EAS') Order by name

open dbCursor
FETCH NEXT FROM dbCursor INTO @DbName
    WHILE @@FETCH_STATUS = 0
        BEGIN
			set @BackupName = UPPER(@DbName)

		-- Execute SHRINK
		--	DBCC SHRINKDATABASE (@DbName, TRUNCATEONLY)

			set @BackupDest = 'C:\Backup_ArcaEvo\' + UPPER(@DbName) + '.BAK'
			set @dropDevice = 'sp_dropdevice '  + '''' + @BackupName + '''' + ', DELFILE'
			set @addDevice = 'sp_addumpdevice ' +  '''disk''' + ', ''' + @BackupName + ''', ''' + @BackupDest + ''''
			--set @command= 'backup database ' + @dbname + ' to disk=''' + @BackupDest+'''with copy_only'
			set @command= 'backup database ' + @dbname + ' to ' + @BackupName
			--Output
			Print '*************************************************************'
			Print 'Drop Device ' + @dropDevice
			exec (@dropDevice)
			Print '*************************************************************'
			Print 'Add Device ' + @addDevice
			exec (@addDevice)
			Print '*************************************************************'
			Print 'BackUp of Db ''' + UPPER(@srv) + '.' + UPPER(@DbName) + ''' performed by: ' + UPPER(@UsrName) + ' at ' + convert(varchar(25),getdate(),100)
			Print 'BackUp Source ' + @BackupDest + ' ' + @BackupName
			Print ''
			Print 'System SQL message: '
			Print ''
			--Execute commands
			exec (@command)
		
FETCH NEXT FROM dbCursor INTO @DbName
END
close dbCursor
deallocate dbCursor